<?php  
$redirect_url = user_url('plans');  
$form_attributes = array('class' => 'form actionForm', 'data-redirect' => $redirect_url, 'method' => "POST");  
$form_hidden = [ 'id' => @$item->id ];  
$class_element = app_config('template')['form']['class_element'];  
$class_element_editor = app_config('template')['form']['class_element_editor'];  
$class_element_select = app_config('template')['form']['class_element_select'];  
  
$general_elements = [  
  [  
    'label'      => form_label('Plan Name'),  
    'element'    => form_input(['name' => 'name', 'value' => @$item->name, 'type' => 'text', 'readonly' => 'readonly', 'class' => $class_element]),  
    'class_main' => "col-md-12",  
  ],  
  [  
    'label'      => form_label('Plan Price'),  
    'element'    => form_input(['name' => 'price', 'value' => @$item->final_price, 'type' => 'text', 'readonly' => 'readonly', 'class' => $class_element]),  
    'class_main' => "col-md-12",  
  ],  
];  
  
$data['modal_title'] = 'Buy this Plan';  
?>  

<style>
  .coupon {
    display: none;
    margin-top: 20px;
    animation: fadeIn 0.3s ease-in-out;
  }

  .coupon-btn {
    display: inline-block;
    margin-top: 20px;
    cursor: pointer;
    color: #007bff;
    font-weight: 500;
    font-size: 14px;
  }

  .coupon-btn:hover {
    text-decoration: underline;
  }

  .input-group {
    display: flex;
    gap: 10px;
    align-items: center;
  }

  .coupon-code {
    flex: 1;
    padding: 10px;
    border-radius: 4px;
    border: 1px solid #ccc;
  }

  #apply-coupon-btn {
    padding: 10px 14px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 4px;
    transition: background-color 0.2s ease;
  }

  #apply-coupon-btn:hover {
    background-color: #0056b3;
  }

  #coupon-result {
    margin-top: 10px;
    font-size: 14px;
    display: block;
  }

  #coupon-result.success {
    color: green;
  }

  #coupon-result.error {
    color: red;
  }

  @keyframes fadeIn {
    from {
      opacity: 0;
      transform: translateY(-5px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
</style>

<?= view('layouts/common/modal/modal_top', $data); ?>
<?= form_open('', $form_attributes, $form_hidden); ?>

<div class="modal-body mb-2">
  <div class="row justify-content-md-center">
    <?= render_elements_form($general_elements); ?>

    <!-- Coupon input box -->
    <div class="col-md-12 coupon">
      <div class="input-group">
        <input type="text" name="coupon" class="form-control coupon-code" placeholder="Enter coupon code" aria-label="Coupon Code">
        <button class="btn" type="button" id="apply-coupon-btn">
          <i class="fa-regular fa-square-caret-right"></i>
        </button>
      </div>
      <span id="coupon-result"></span>
    </div>
  </div>

  <!-- Toggle button -->
  <div class="text-center">
    <span class="coupon-btn">Have a coupon? <span class="text-primary">Click here to enter</span></span>
  </div>
</div>

<?= modal_buttons2('BUY NOW'); ?>
<?= form_close(); ?>
<?= view('layouts/common/modal/modal_bottom', $data); ?>

<script>
  $(document).ready(function () {
    $(".coupon-btn").click(function () {
      $(".coupon").slideToggle(200);
    });

    $("#apply-coupon-btn").click(function () {
      var coupon = $(".coupon-code").val();
      var id = "<?= $item->id ?>";

      $.ajax({
        url: "<?= user_url('buy-plan/apply_coupon'); ?>",
        type: "POST",
        data: {
          token: token,
          coupon: coupon,
          id: id
        },
        success: function (response) {
          response = JSON.parse(response);
          var result = $("#coupon-result");

          result
            .removeClass("success error")
            .addClass(response.status === "success" ? "success" : "error")
            .text(response.message);

          if (response.status === "success") {
            $("#apply-coupon-btn").addClass("d-none");
          }

          notify(response.message, response.status);
        }
      });
    });
  });
</script>