<?php
$redirect = session('ref_url') ?? user_url();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Sign Up - NagorikPay</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto&display=swap">
  <style>
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #fff;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 400px;
      margin: 50px auto;
      padding: 20px;
    }

    .form-box {
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 30px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .form-box h4 {
      text-align: center;
      margin-bottom: 20px;
    }

    .form-group {
      margin-bottom: 15px;
    }

    label, .toggle-wrapper span, .signin-link a, .form-box h4 {
      font-size: 14px;
      color: #333;
    }

    input[type="text"],
    input[type="email"],
    input[type="password"] {
      width: 100%;
      padding: 10px;
      border: 1px solid #ccc;
      border-radius: 5px;
      font-size: 14px;
      box-sizing: border-box;
    }

    .toggle-wrapper {
      display: flex;
      align-items: center;
      margin-bottom: 20px;
    }

    .switch {
      position: relative;
      display: inline-block;
      width: 58px;
      height: 26px;
      margin-right: 18px;
    }

    .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }

    .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background-color: #ccc;
      transition: 0.4s;
      border-radius: 24px;
    }

    .slider::before {
      position: absolute;
      content: "";
      height: 20px;
      width: 20px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: 0.4s;
      border-radius: 50%;
    }

    .switch input:checked + .slider {
      background-color: #007bff;
    }

    .switch input:checked + .slider::before {
      transform: translateX(18px);
    }

    .btn-primary {
      width: 100%;
      padding: 15px 0;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 4px;
      font-size: 14px;
      font-weight: 500;
      line-height: 1.2;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    .btn-primary:hover {
      background-color: #0056b3;
    }

    .signin-link {
      text-align: center;
      margin-top: 15px;
      font-size: 14px;
    }

    .signin-link a {
      text-decoration: none;
    }

    .signin-link a:hover {
      text-decoration: underline;
    }

    /* ✅ Gradient animated text */
    .gradient-text {
      background: linear-gradient(270deg, #ff005e, #fbb034, #00d0ff, #8e2de2, #ff005e);
      background-size: 800% 800%;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      animation: gradientMove 6s ease infinite;
    }

    @keyframes gradientMove {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="form-box">
      <h4 class="gradient-text">Sign Up to your Account</h4>
      <?= form_open(base_url('sign-up'), 'class="actionForm needs-validation" novalidate data-redirect="' . $redirect . '"') ?>

      <div class="form-group">
        <label for="first_name" class="gradient-text">First Name</label>
        <input id="first_name" type="text" name="first_name" placeholder="John" required value="<?= set_value('first_name') ?>">
      </div>

      <div class="form-group">
        <label for="last_name" class="gradient-text">Last Name</label>
        <input id="last_name" type="text" name="last_name" placeholder="Doe" required value="<?= set_value('last_name') ?>">
      </div>

      <div class="form-group">
        <label for="phone" class="gradient-text">Mobile Number</label>
        <input id="phone" type="text" name="phone" placeholder="0152141*****" required value="<?= set_value('phone') ?>">
      </div>

      <div class="form-group">
        <label for="email" class="gradient-text">Email</label>
        <input id="email" type="email" name="email" placeholder="john@example.com" required value="<?= set_value('email') ?>">
      </div>

      <div class="form-group">
        <label for="password" class="gradient-text">Password</label>
        <input id="password" type="password" name="password" placeholder="Enter Password" required>
      </div>

      <div class="form-group">
        <label for="c_password" class="gradient-text">Confirm Password</label>
        <input id="c_password" type="password" name="c_password" placeholder="Confirm Password" required>
      </div>

      <div class="toggle-wrapper">
        <label class="switch">
          <input type="checkbox" name="agree" required>
          <span class="slider"></span>
        </label>
        <span class="gradient-text">I read and agree to Terms & Conditions</span>
      </div>

      <button type="submit" class="btn-primary">Sign UP</button>
      <?= form_close(); ?>

      <div class="signin-link">
        <span class="gradient-text">Already have an account? <a href="<?= base_url('sign-in') ?>" class="gradient-text">Sign in here</a></span>
      </div>
    </div>
  </div>
</body>
</html>