<?php
$cookie_email = !empty(get_cookie("c_cookie_email")) ? encrypt_decode(get_cookie("c_cookie_email")) : "";
$cookie_pass = !empty(get_cookie("c_cookie_pass")) ? encrypt_decode(get_cookie("c_cookie_pass")) : "";
$redirect = session('ref_url') ?? user_url();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login - NagorikPay</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto&display=swap">
  <style>
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #fff;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 400px;
      margin: 80px auto;
      padding: 20px;
    }

    .form-box {
      background-color: #ffffff;
      padding: 30px 25px;
      border-radius: 10px;
      box-shadow: 0px 4px 20px rgba(0, 0, 0, 0.1);
    }

    .form-box h2 {
      text-align: center;
      margin-bottom: 25px;
      font-size: 22px;
    }

    .form-group {
      margin-bottom: 20px;
    }

    label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
    }

    input[type="email"],
    input[type="password"] {
      width: 100%;
      padding: 10px 12px;
      font-size: 14px;
      border-radius: 6px;
      border: 1px solid #ccc;
      outline: none;
      transition: border 0.3s;
    }

    input[type="email"]:focus,
    input[type="password"]:focus {
      border-color: #007bff;
    }

    .remember-forgot {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 14px;
      margin-bottom: 20px;
    }

    .switch-label {
      display: flex;
      align-items: center;
      gap: 10px;
      flex-direction: row-reverse;
    }

    .switch {
      position: relative;
      display: inline-block;
      width: 36px;
      height: 20px;
    }

    .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }

    .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background-color: #ccc;
      transition: 0.4s;
      border-radius: 20px;
    }

    .slider::before {
      position: absolute;
      content: "";
      height: 14px;
      width: 14px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: 0.4s;
      border-radius: 50%;
    }

    .switch input:checked + .slider {
      background-color: #007bff;
    }

    .switch input:checked + .slider::before {
      transform: translateX(16px);
    }

    .btn-primary {
      width: 100%;
      background-color: #007bff;
      border: none;
      color: #fff;
      padding: 12px;
      font-size: 16px;
      border-radius: 6px;
      cursor: pointer;
    }

    .btn-primary:hover {
      background-color: #0056b3;
    }

    .divider {
      display: flex;
      align-items: center;
      text-align: center;
      color: #999;
      margin: 20px 0;
    }

    .divider::before,
    .divider::after {
      content: '';
      flex: 1;
      border-bottom: 1px solid #ddd;
    }

    .divider:not(:empty)::before {
      margin-right: .75em;
    }

    .divider:not(:empty)::after {
      margin-left: .75em;
    }

    .google-login {
      display: flex;
      justify-content: center;
    }

    .google-btn {
      background-color: #ffffff;
      border: 1px solid #ccc;
      padding: 10px 16px;
      border-radius: 6px;
      cursor: pointer;
      display: flex;
      align-items: center;
      font-size: 14px;
      color: #333;
      text-decoration: none;
    }

    .google-btn img {
      width: 18px;
      height: 18px;
      margin-right: 8px;
    }

    .signup-text {
      text-align: center;
      margin-top: 20px;
      font-size: 14px;
    }

    .signup-text a {
      text-decoration: none;
    }

    /* Gradient animated text */
    .gradient-text {
      background: linear-gradient(270deg, #ff005e, #fbb034, #00d0ff, #8e2de2, #ff005e);
      background-size: 800% 800%;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      animation: gradientMove 6s ease infinite;
    }

    @keyframes gradientMove {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
  </style>
</head>

<body>

  <div class="container">
    <div class="form-box">
      <h2 class="gradient-text">Please log in to your account</h2>
      <?= form_open(base_url('sign-in'), 'class="actionForm needs-validation" novalidate data-redirect="' . $redirect . '"') ?>
        <div class="form-group">
          <label for="email" class="gradient-text">Email</label>
          <input id="email" type="email" name="email" required autofocus value="<?= !empty($cookie_email) ? $cookie_email : set_value('email') ?>">
        </div>
        <div class="form-group">
          <label for="password" class="gradient-text">Password</label>
          <input id="password" type="password" name="password" required value="<?= !empty($cookie_pass) ? $cookie_pass : set_value('password') ?>">
        </div>
        <div class="remember-forgot">
          <div class="switch-label">
            <label class="gradient-text">Remember Me</label>
            <label class="switch">
              <input type="checkbox" name="remember" <?= !empty($cookie_email) ? 'checked' : '' ?>>
              <span class="slider"></span>
            </label>
          </div>
          <a href="<?= base_url('password-reset') ?>" class="gradient-text">Forgot Password?</a>
        </div>
        <button type="submit" class="btn-primary">Sign in</button>
      <?= form_close(); ?>

      <?php if (get_option('google_login')) : ?>
        <div class="divider gradient-text">OR SIGN IN WITH</div>
        <div class="google-login">
          <a href="<?= base_url('auth/google_process') ?>" class="google-btn">
            <img src="https://www.gstatic.com/firebasejs/ui/2.0.0/images/auth/google.svg" alt="Google Logo"> Google
          </a>
        </div>
      <?php endif; ?>

      <div class="signup-text gradient-text">
        Don't have an account yet? <a href="<?= base_url('sign-up') ?>" class="gradient-text">Sign up here</a>
      </div>
    </div>
  </div>

</body>
</html>