<div id="app">
  <style>
    * {
      box-sizing: border-box;
    }

    html, body {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: 'Roboto', sans-serif;
      background-color: #fff;
    }

    .center-wrapper {
      height: 100%;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 16px;
    }

    .forgot-container {
      width: 100%;
      max-width: 360px;
      text-align: center;
    }

    .forgot-container h2 {
      font-size: 18px;
      margin-bottom: 10px;
      color: #000;
    }

    .forgot-container p {
      font-size: 13px;
      color: #444;
      margin-bottom: 20px;
      line-height: 1.4;
    }

    .form-group {
      text-align: left;
      margin-bottom: 12px;
    }

    .form-group label {
      font-size: 13px;
      color: #000;
      margin-bottom: 5px;
      display: block;
    }

    .form-control {
      width: 100%;
      padding: 10px 12px;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 13px;
    }

    .btn-submit {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-size: 14px;
      font-weight: 500;
      cursor: pointer;
      margin-top: 8px;
      transition: background-color 0.3s;
    }

    .btn-submit:hover {
      background-color: #0056b3;
    }

    .bottom-link {
      margin-top: 20px;
      font-size: 13px;
      color: #333;
    }

    .bottom-link a {
      color: #007bff;
      text-decoration: none;
      font-weight: 500;
    }

    .bottom-link a:hover {
      text-decoration: underline;
    }

    @media screen and (max-width: 360px) {
      .forgot-container h2 {
        font-size: 16px;
      }

      .form-control,
      .btn-submit {
        font-size: 12px;
        padding: 10px;
      }

      .forgot-container p {
        font-size: 12px;
      }
    }
  </style>

  <div class="center-wrapper">
    <div class="forgot-container">
      <h2>Forgot Password</h2>
      <p>Enter your email address and we'll send you a link to reset your password.</p>

      <?= form_open(url_to('password-reset'), 'class="actionForm" data-redirect="user"') ?>
        <div class="form-group">
          <label for="email">Email</label>
          <input id="email" type="email" class="form-control" name="email" placeholder="jhon@example.com" required autofocus>
        </div>

        <button type="submit" class="btn-submit">Continue</button>
      <?= form_close(); ?>

      <div class="bottom-link">
        Don't have an account? <a href="<?= base_url('sign-up') ?>">Sign up here</a>
      </div>
    </div>
  </div>
</div>